define(['modules/page/popup/popup-view'], function (PopupView) {
    'use strict';

    return PopupView.extend({
        className: 'warning',
        events: {
            'popupbeforeposition': 'styleMaxHeight',
            'popupafteropen': 'focusOnHeader',
            'popupafterclose': 'destroy',
            'click .warning-continue-btn': 'continue',
            'click button': 'closePopup',
        },
        addAriaRole: function() {
            this.$el.attr('role', 'alertdialog')
                .attr('aria-labelledby', 'dialogTitle')
                .attr('aria-describedby', 'dialogDesc');
        },
    });
});
